#include "stdafx.h"
#include "win_demo.h"
#include "DialogMultiobjParam.h"
#include "afxdialogex.h"
#include "common_struct.h"
#include "sdks.h"
#include "perser_json.h"
#include "pack_json.h"


IMPLEMENT_DYNAMIC(CDialogMultiobjParam, CDialogEx)
extern int m_handle;
CDialogMultiobjParam::CDialogMultiobjParam(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_DIALOG_MULTIOBJ_PARAM, pParent)
{

}

CDialogMultiobjParam::~CDialogMultiobjParam()
{
}

void CDialogMultiobjParam::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CHECK_FACE_DETECTION, m_face_detection);
	DDX_Control(pDX, IDC_CHECK_FULLBODY_DETECTION, m_fullboy_detection);
	DDX_Control(pDX, IDC_CHECK_VEHICLE_DETECTION, m_vehicle_detection);
	DDX_Control(pDX, IDC_CHECK_FTP_UPLOAD, m_ftp_upload);
	DDX_Control(pDX, IDC_CHECK_FTP_FULL_UPLOAD, m_ftp_full_upload);
	DDX_Control(pDX, IDC_COMBO_RELIABILITY, m_reliability);
	DDX_Control(pDX, IDC_EDIT_FULLBODY_WIDTH, m_fullbody_width);
	DDX_Control(pDX, IDC_EDIT_VEHICLE_WIDTH, m_vehicle_width);
	DDX_Control(pDX, IDC_COMBO_PIC_QUALITY, m_pic_quality);
	DDX_Control(pDX, IDC_COMBO_SNAP_MODE, m_snap_mode);
	DDX_Control(pDX, IDC_EDIT_FACE_WIDTH, m_face_width);
	DDX_Control(pDX, IDC_COMBO_SNAP_INTERVAL, m_snap_interval);
}

jy_dev_ai_multi_object_ability_t stAIObjectAbility = { 0 };
jy_dev_ai_multi_object_param_t stAIObjectParam = { 0 };
BOOL CDialogMultiobjParam::OnInitMultiobjParam()
{
	char *p_result = NULL;
	int nRet = 0;
	CString strins;
	memset(&stAIObjectAbility, 0, sizeof(jy_dev_ai_multi_object_ability_t));
	nRet = sdks_get_ai_multi_object_detect_ability(m_handle, 1, &p_result);
	if ((!nRet) || (NULL != p_result))
	{
		json_perser_ai_multi_object_detect_ability(p_result, &stAIObjectAbility);
	}
	if (stAIObjectAbility.face_enable)
	{
		m_face_detection.EnableWindow(TRUE);
	}
	if (stAIObjectAbility.fullbody_enable)
	{
		m_fullboy_detection.EnableWindow(TRUE);
	}
	if (stAIObjectAbility.vehicle_enable)
	{
		m_vehicle_detection.EnableWindow(TRUE);
	}
	nRet = sdks_get_ai_multi_object_detect_param(m_handle, 1, &p_result);
	if (!nRet)
	{
		memset(&stAIObjectParam, 0, sizeof(jy_dev_ai_multi_object_param_t));
		json_perser_ai_multi_object_detect_param(p_result, &stAIObjectParam);
		((CButton*)GetDlgItem(IDC_CHECK_FACE_DETECTION))->SetCheck(0);
		if (stAIObjectParam.face_enable)
		{
			((CButton*)GetDlgItem(IDC_CHECK_FACE_DETECTION))->SetCheck(1);
			m_face_width.EnableWindow(TRUE);
		}
		((CButton*)GetDlgItem(IDC_CHECK_FULLBODY_DETECTION))->SetCheck(0);
		if (stAIObjectParam.fullbody_enable)
		{
			((CButton*)GetDlgItem(IDC_CHECK_FULLBODY_DETECTION))->SetCheck(1);
			m_fullbody_width.EnableWindow(TRUE);
		}
		((CButton*)GetDlgItem(IDC_CHECK_VEHICLE_DETECTION))->SetCheck(0);
		if (stAIObjectParam.vehicle_enable)
		{
			((CButton*)GetDlgItem(IDC_CHECK_VEHICLE_DETECTION))->SetCheck(1);
			m_vehicle_width.EnableWindow(TRUE);
		}
		((CButton*)GetDlgItem(IDC_CHECK_FTP_UPLOAD))->SetCheck(0);
		if (stAIObjectParam.ftp_upload_enable)
		{
			((CButton*)GetDlgItem(IDC_CHECK_FTP_UPLOAD))->SetCheck(1);
		}
		((CButton*)GetDlgItem(IDC_CHECK_FTP_FULL_UPLOAD))->SetCheck(0);
		if (stAIObjectParam.ftp_upload_full_enable)
		{
			((CButton*)GetDlgItem(IDC_CHECK_FTP_FULL_UPLOAD))->SetCheck(1);
		}
		strins.Format(_T("%d"), stAIObjectParam.face_min_width);
		m_face_width.SetWindowTextA(strins);
		strins.Format(_T("%d"), stAIObjectParam.fullbody_min_width);
		m_fullbody_width.SetWindowTextA(strins);
		strins.Format(_T("%d"), stAIObjectParam.vehicle_min_width);
		m_vehicle_width.SetWindowTextA(strins);
		m_reliability.InsertString(0, TEXT("Low"));
		m_reliability.InsertString(1, TEXT("Middle"));
		m_reliability.InsertString(2, TEXT("High"));
		m_reliability.SetCurSel(1);
		if (stAIObjectParam.reliabilty <= 30)
		{
			m_reliability.SetCurSel(0);
		}
		else if (stAIObjectParam.reliabilty >30 && stAIObjectParam.reliabilty <= 60)
		{
			m_reliability.SetCurSel(1);
		}
		else
		{
			m_reliability.SetCurSel(2);
		}
		m_pic_quality.InsertString(0, TEXT("Low"));
		m_pic_quality.InsertString(1, TEXT("Middle"));
		m_pic_quality.InsertString(2, TEXT("High"));
		m_pic_quality.InsertString(3, TEXT("Highest"));
		if ((stAIObjectParam.pic_quality >= 20) && (stAIObjectParam.pic_quality <= 30))
		{
			m_pic_quality.SetCurSel(0);
		}
		else if ((stAIObjectParam.reliabilty > 30) && (stAIObjectParam.reliabilty <= 60))
		{
			m_pic_quality.SetCurSel(1);
		}
		else if ((stAIObjectParam.pic_quality > 60) && (stAIObjectParam.reliabilty <= 80))
		{
			m_pic_quality.SetCurSel(2);
		}
		else if ((stAIObjectParam.pic_quality > 80) && (stAIObjectParam.pic_quality <= 99))
		{
			m_pic_quality.SetCurSel(3);
		}
		else
		{
			m_pic_quality.SetCurSel(1);
		}
		m_snap_mode.InsertString(0, TEXT("Timing"));
		m_snap_mode.InsertString(1, TEXT("Optimal"));
		m_snap_mode.SetCurSel(stAIObjectParam.snap_picture_mode);
		if (1 == stAIObjectParam.snap_picture_mode)
		{
			m_snap_interval.EnableWindow(FALSE);
		}
		m_snap_interval.InsertString(0, TEXT("1"));
		m_snap_interval.InsertString(1, TEXT("2"));
		m_snap_interval.InsertString(2, TEXT("3"));
		m_snap_interval.InsertString(3, TEXT("4"));
		m_snap_interval.InsertString(4, TEXT("5"));
		m_snap_interval.InsertString(5, TEXT("6"));
		m_snap_interval.InsertString(6, TEXT("7"));
		m_snap_interval.InsertString(7, TEXT("8"));
		m_snap_interval.InsertString(8, TEXT("9"));
		m_snap_interval.InsertString(9, TEXT("10"));
		m_snap_interval.SetCurSel(stAIObjectParam.upload_interval - 1);

	}
	return TRUE;
}

BEGIN_MESSAGE_MAP(CDialogMultiobjParam, CDialogEx)
	ON_BN_CLICKED(IDC_CHECK_FACE_DETECTION, &CDialogMultiobjParam::OnBnClickedCheckDetection)
	ON_BN_CLICKED(IDC_CHECK_FULLBODY_DETECTION, &CDialogMultiobjParam::OnBnClickedCheckDetection)
	ON_BN_CLICKED(IDC_CHECK_VEHICLE_DETECTION, &CDialogMultiobjParam::OnBnClickedCheckDetection)
	ON_CBN_SELCHANGE(IDC_COMBO_SNAP_MODE, &CDialogMultiobjParam::OnCbnSelchangeComboSnapMode)
	ON_BN_CLICKED(IDOK, &CDialogMultiobjParam::OnBnClickedOk)
END_MESSAGE_MAP()


void CDialogMultiobjParam::OnBnClickedCheckDetection()
{
	if (((CButton*)GetDlgItem(IDC_CHECK_FACE_DETECTION))->GetCheck() == TRUE)
	{
		m_face_width.EnableWindow(TRUE);
	}
	else
	{
		m_face_width.EnableWindow(FALSE);
	}
	if (((CButton*)GetDlgItem(IDC_CHECK_FULLBODY_DETECTION))->GetCheck() == TRUE)
	{
		m_fullbody_width.EnableWindow(TRUE);
	}
	else
	{
		m_fullbody_width.EnableWindow(FALSE);
	}
	if (((CButton*)GetDlgItem(IDC_CHECK_VEHICLE_DETECTION))->GetCheck() == TRUE)
	{
		m_vehicle_width.EnableWindow(TRUE);
	}
	else
	{
		m_vehicle_width.EnableWindow(FALSE);
	}
}


void CDialogMultiobjParam::OnCbnSelchangeComboSnapMode()
{
	int mode_index = m_snap_mode.GetCurSel();
	if (0 == mode_index)
	{
		m_snap_interval.EnableWindow(TRUE);
	}
	else if (1 == mode_index)
	{
		m_snap_interval.EnableWindow(FALSE);
	}
}


void CDialogMultiobjParam::OnBnClickedOk()
{
	CString str_tmp;
	int index_tmp;
	char *p_param = NULL;
	CDialogEx::OnOK();
	stAIObjectParam.face_enable = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_FACE_DETECTION))->GetCheck() == TRUE)
	{
		stAIObjectParam.face_enable = 1;
	}
	stAIObjectParam.fullbody_enable = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_FULLBODY_DETECTION))->GetCheck() == TRUE)
	{
		stAIObjectParam.fullbody_enable = 1;
	}
	stAIObjectParam.vehicle_enable = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_VEHICLE_DETECTION))->GetCheck() == TRUE)
	{
		stAIObjectParam.vehicle_enable = 1;
	}
	stAIObjectParam.ftp_upload_enable = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_FTP_UPLOAD))->GetCheck() == TRUE)
	{
		stAIObjectParam.ftp_upload_enable = 1;
	}
	stAIObjectParam.ftp_upload_full_enable = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_FTP_FULL_UPLOAD))->GetCheck() == TRUE)
	{
		stAIObjectParam.ftp_upload_full_enable = 1;
	}
	m_face_width.GetWindowText(str_tmp);
	stAIObjectParam.face_min_width= _ttoi(str_tmp);
	if ((stAIObjectParam.face_min_width > stAIObjectParam.face_max_width) || (stAIObjectParam.face_min_width < 30))
	{
		MessageBoxA("Face min pixel width set error!");
	}
	m_fullbody_width.GetWindowText(str_tmp);
	stAIObjectParam.fullbody_min_width = _ttoi(str_tmp);
	if ((stAIObjectParam.fullbody_min_width > stAIObjectParam.fullbody_max_width) || (stAIObjectParam.fullbody_min_width < 30))
	{
		MessageBoxA("Fullbody min pixel width set error!");
	}
	m_vehicle_width.GetWindowText(str_tmp);
	stAIObjectParam.vehicle_min_width = _ttoi(str_tmp);
	if ((stAIObjectParam.vehicle_min_width > stAIObjectParam.vehicle_max_width) || (stAIObjectParam.vehicle_min_width < 30))
	{
		MessageBoxA("Vehicle min pixel width set error!");
	}
	index_tmp = m_reliability.GetCurSel();
	if (0 == index_tmp)
	{
		stAIObjectParam.reliabilty = 30;
	}
	else if (1 == index_tmp)
	{
		stAIObjectParam.reliabilty = 60;
	}
	else if (2 == index_tmp)
	{
		stAIObjectParam.reliabilty = 90;
	}
	index_tmp = m_pic_quality.GetCurSel();
	if (0 == index_tmp)
	{
		stAIObjectParam.reliabilty = 30;
	}
	else if (1 == index_tmp)
	{
		stAIObjectParam.reliabilty = 60;
	}
	else if (2 == index_tmp)
	{
		stAIObjectParam.reliabilty = 80;
	}
	else if (3 == index_tmp)
	{
		stAIObjectParam.reliabilty = 99;
	}
	stAIObjectParam.snap_picture_mode = m_snap_mode.GetCurSel();
	stAIObjectParam.upload_interval =  m_snap_interval.GetCurSel() + 1;
	UINT i = 0;
	i = MessageBoxA(_T("Are you sure you want multiple targets?"), _T("Prompt"), MB_YESNO | MB_ICONQUESTION);
	if (IDYES == i)
	{
		pack_json_ai_multi_object_detect_param(&stAIObjectParam, &p_param);
		int nRet = sdks_set_ai_multi_object_detect_param(m_handle, 1, p_param);
		if (nRet) {
			MessageBoxA("Set AI multi object detect para fail!");
		}
	}	
}
